# Factor Graph Data Store - Programming Language Selection

* Status: proposed
* Deciders: Richard Petty, Jasmine Moore, Willow Malo, Sebastian King, Darin Bunker
* Date: 2024-08-08

Technical Story: Determine which programming language to use to write the Factor Graph Store

## Context and Problem Statement

The Factor Graph Data Store code must be fast, small, and have minimal runtime dependencies.   The core funtions must be able to be exposed as a library (.dll, .so, etc) and linkable during compile time into the Agent binary.

## Decision Drivers <!-- optional -->

* Speed of execution - How optimized is the code generated by the programming language?
* Memory Safety - How likely is it that errors will occur due to improper memory handling?
* Thread Safety - How likely is it that multi-threading will cause errors?
* Cross Platorm - Must be able to be compiled for Linux, Mac, Windows, and multiple processor types including Intel/AMD, ARM, etc.
* Size of compiled code - How big will the library be once it's built for production
* Ability to hide secret sauce - Does the production compiled library expose the underlying source code?
* Runtime Dependencies - Does the runtime require any addtional dependencies, such as a Java JVM or an interpreter.
* Interopability - Can the compiled library interact with code built in other languages?
* Developer Ramp Up Time - How long will it take our developers to come up to speed?

## Considered Options

* Rust
* C++, C#
* Interpeted languages such as Java, Python, etc.

## Decision Outcome

Chosen option: Rust, because it provides tight compiled code, the best memory safety, can support multiple platforms and has 0 runtime dependencies.  In addtion, our developers are already familiar with Rust and how to build high quality code using Rust. 


## Pros and Cons of the Options <!-- optional -->

### Option 1: Rust

Rust compiles to binary with no runtime dependencies or garbage collector.  The compiler handles memory safety and thread safety. 

#### [option 1] is good, because
* Small, tight compiled code
* Memory Safety is built in
* Thread Safety is built in
* Can be compiled for virtually any platform
* No Runtime Dependencies
* Existing development team already ramped up

#### [option 1] is bad, because
* Lack of availability of developers good at Rust
* Rust can be difficult to learn

### Option 2: [option 2]

C++ or C# can be compiled for virtually any platform, and if built correctly won't require additional runtime depencencies.   C++ compilers exist for almost every platform

#### [option 2] is good, because
* Small, tight compiled code
* Availabilty of C++ developers
* Can be compiled for virtually any platform
* No runtime depedencies
 

#### [option 2] is bad, because
* Developers have to code correctly to ensure memory safety
* Developers have to implement their own threading model or leverage a threading framework
* Memory and Thread Safety not part of the compiler
* Existing team has not used C++ or any C variant in a while

### Option 3: [option 3]

Interpreted Languages  (Java, Node, Python, etc)

#### [option 3] is good, because
* Fast and easy for developers
* Availability of developers


#### [option 3] is bad, because
* Runtime Dependencies
* Slow execution time
* Source Code exposed
* Interoperability with other components is questionable

